# coding: utf-8
from __future__ import unicode_literals

import functools

from django.conf import settings

import ylock


lock_manager = ylock.create_manager(**settings.YLOCK)


def locked(lock_name, block=False, common_lock_name=True):

    def decorator(func):

        @functools.wraps(func)
        def wrapper(*args, **kwargs):
            _lock_name = '%s_%s' % (settings.STATIC_API_NAMES_PREFIX, lock_name)
            with lock_manager.lock(_lock_name, block=block, common_lock_name=common_lock_name) as is_locked:
                if is_locked:
                    return func(*args, **kwargs)

        return wrapper

    return decorator
