# coding: utf-8
from __future__ import unicode_literals

from optparse import make_option

from django.core.management.base import BaseCommand

from static_api import actions


class Command(BaseCommand):
    option_list = BaseCommand.option_list + (
        make_option('--entity',
                    action='store',
                    default=None,
                    help='Entity to initialize'),
        make_option('--reset',
                    action='store_true',
                    default=False,
                    help='Reset before init'),
        make_option('--meta',
                    action='store_true',
                    default=False,
                    help='Rest also meta collections'),
        )

    def handle(self, *args, **options):
        actions.run_init(options['entity'], options['reset'], options['meta'])
