# coding: utf-8
from __future__ import unicode_literals

from optparse import make_option

from django.core.management.base import BaseCommand

from static_api.helpers import get_current_master_deltas


class Command(BaseCommand):
    option_list = BaseCommand.option_list + (
        make_option('--treshold',
                    action='store',
                    default=600,
                    type='int',
                    help='FAIL if time_delta reaches this value'),
    )

    def handle(self, *args, **options):
        try:
            deltas = get_current_master_deltas()
        except Exception as e:
            return "2;FAILED to retrieve deltas: {}".format(e)

        delta_time = deltas['delta_time']

        if delta_time < 0:
            return "2;FAIL: unknown delay (probably init in progress)"

        if delta_time > options['treshold']:
            return "2;Delay is too big: {delta:.3f} > {treshold}".format(
                delta=delta_time,
                treshold=options['treshold'],
            )

        return "0;OK"
