# coding: utf-8
from __future__ import unicode_literals

import time
import socket

from django.conf import settings


def send_graphite_metrics(metrics, timestamp=None):
    timestamp = int(timestamp or time.time())
    data = []

    for path, value in metrics.items():
        data.append("{path} {value} {timestamp}".format(
            path=path,
            value=value,
            timestamp=timestamp,
        ))

    graphite_address = (
        settings.STATIC_API_GRAPHITE_HOST,
        settings.STATIC_API_GRAPHITE_PORT,
    )

    sock = socket.socket(settings.STATIC_API_GRAPHITE_AF_INET, socket.SOCK_STREAM)
    sock.connect(graphite_address)

    sock.sendall(str('\n'.join(data) + '\n'))
    sock.close()
