# coding: utf-8
from __future__ import absolute_import

import logging

from celery import beat

from static_api import storage


log = logging.getLogger(__name__)


class ApiScheduler(beat.PersistentScheduler):
    def maybe_due(self, entry, publisher=None):
        is_due, next_time_to_run = entry.is_due()

        if is_due:
            try:
                current_state = storage.manager.get_state_manager().get_state()
            except storage.exceptions.StorageError:
                # Ловим все ошибки стораджа и просто ждем слелующего тика
                return next_time_to_run
            else:
                if entry.task == 'static_api.tasks.update' and current_state['name'] != 'update':
                    return next_time_to_run

        return super(ApiScheduler, self).maybe_due(entry, publisher)


