# coding: utf-8

import socket
import os

BASE_DIR = os.path.abspath(os.path.dirname(__file__))

STATIC_API_ENTITY_COLLECTIONS = []

STATIC_API_META_COLLECTIONS = ['ylock_locks', 'event', 'state']

STATIC_API_MESSAGES_COLLECTION = 'event'

STATIC_API_CHECK_FIELDS_ACCESS = False
STATIC_API_FIELD_ACCESS_RULES_COLLECTION = ''
STATIC_API_WILDCARD_FIELD_ACCESS = '*'

STATIC_API_GRAPHITE_HOST = '127.0.0.1'
STATIC_API_GRAPHITE_PORT = 42000
STATIC_API_GRAPHITE_VIEWER_PREFIX = 'https://ps-graphite.yandex-team.ru'
STATIC_API_GRAPHITE_AF_INET = socket.AF_INET

STATIC_API_MONGO_SOCKET_TIMEOUT = 5000
STATIC_API_MONGO_CONNECT_TIMEOUT = 1000
STATIC_API_MONGO_MAX_POOL_SIZE = 2
STATIC_API_QUERY_TIMEOUT = 50000
STATIC_API_DELETED_NESTED_PLACEHOLDER_EXTRA = {}

STATIC_API_READ_NAMESPACE_CACHE_SECONDS = 7.0

# маппинг монгоколлекций на индексы, которые в них должны быть
API_INDEXES = {}
# маппинг дополнительных индексов дополнительных коллекций
MISC_INDEXES = {}

# Must be defined in project settings
# STATIC_API_GRAPHITE_METRIC_PREFIX = 'one_sec.example_api'

TEMPLATES = [
    {
        'BACKEND': 'django_jinja.backend.Jinja2',
        'APP_DIRS': True,
        'DIRS': [
            os.path.join(BASE_DIR, 'templates'),
        ],
        'OPTIONS': {
            'match_extension': '.html',
            'context_processors': [
                'django.contrib.auth.context_processors.auth',
                'django.template.context_processors.debug',
                'django.template.context_processors.i18n',
                'django.template.context_processors.media',
                'django.template.context_processors.static',
                'django.template.context_processors.tz',
                'django.contrib.messages.context_processors.messages',
                'static_api.context_processors.common',
            ],
        }
    }
]
