# coding: utf-8
import functools

import six

import pymongo


class StorageError(Exception):
    pass


class _ErrorWrapper(object):
    """Обертывает все pymongo ошибки в StorageError.
    Позаимствовано у Джанги - DatabaseErrorWrapper
    https://github.com/django/django/blob/master/django/db/utils.py#L56
    """
    def __enter__(self):
        pass

    def __exit__(self, exc_type, exc_value, traceback):
        if exc_type is None:
            return

        if issubclass(exc_type, pymongo.errors.PyMongoError):
            new_exc_value = StorageError(*exc_value.args)

            six.reraise(StorageError, new_exc_value, traceback)

    def __call__(self, func):
        @functools.wraps(func)
        def _wrapper(*args, **kwargs):
            with self:
                return func(*args, **kwargs)

        return _wrapper


wrapper = _ErrorWrapper()

