# coding: utf-8


def raise_value_error_for_too_simple_case(path):
    if '.$.' not in path:
        raise ValueError('Use something else for simple updates')


def parse_path_elements(path):
    return path.split('.$.')


def make_elem_identifier(idx):
    return 'el{}'.format(idx)


def make_filter_that_path_element_exists(idx, path_elem):
    iden = make_elem_identifier(idx)
    return {'{}.{}'.format(iden, path_elem): {'$exists': True}}


def make_last_element_filter(path_elem, element_id):
    return {'{}.{}.id'.format('elem', path_elem): element_id}


def make_document_filter(path, element_id):
    return {
        '{path}.id'.format(path=path.replace('.$', '')): element_id
    }


def make_set_path_elements_without_last(path_elems):
    set_path = [path_elems[0]]

    for idx, path_elem in enumerate(path_elems[1:]):
        set_path.append('$[{}]'.format(make_elem_identifier(idx)))
        set_path.append(path_elem)

    return set_path

