# coding: utf-8
import dpath.util
import pql

from django.utils.encoding import smart_str


def _parse_sort(values):
    if isinstance(values, basestring):
        values = [values]

    return pql.sort(map(smart_str, values))[0]['$sort'].items()


def _find_in_dict(d, lookup):
    assert(len(lookup) == 1)

    path, value = lookup.items()[0]

    path = path.replace('$', '*')

    for branch, leaf in dpath.util.search(d, path, yielded=True, separator='.'):
        if leaf == value:
            path = branch

            break
    else:
        raise ValueError('Can\'t find `%s` at: %s' % (value, path))

    return path


def _apply_resolved_path(path, resolved_path):
    bits = path.split('.')
    resolved_bits = resolved_path.split('.')

    assert(len(bits) <= len(resolved_bits))

    for i, bit in enumerate(bits[:]):
        if bit == '$':
            bits[i] = resolved_bits[i]

    return '.'.join(bits)


def _strip_positional_operator(lookup):
    res = {}

    for key in lookup:
        res[key.replace('.$.', '.')] = lookup[key]

    return res


def flatten_dict(d):
    def _inner(d):
        for k, v in d.items():
            if isinstance(v, dict):
                for nested_k, nested_v in _inner(v):
                    yield k + '.' + nested_k, nested_v
            else:
                yield k, v

    return dict(_inner(d))
