# coding: utf-8
from __future__ import unicode_literals

import urlparse

from django.conf import settings
from django.utils.http import urlencode

from django_jinja import library


@library.global_function
def zip(*args, **kwargs):
    import itertools
    return itertools.izip_longest(*args, **kwargs)


@library.global_function
def url(view, *args, **kwargs):
    from django.utils.html import escape
    from django.core.urlresolvers import reverse
    return escape(reverse(view, args=args or None, kwargs=kwargs or None))


@library.global_function
def static(path):
    from django.contrib.staticfiles.storage import staticfiles_storage
    return staticfiles_storage.url(path)


@library.global_function
def versioned_static(path):
    from django.contrib.staticfiles.storage import staticfiles_storage
    return staticfiles_storage.url(settings.API_VERSION + '/' + path)


@library.global_function
def get_schema(schema_name):
    from static_api.schema import SCHEMAS
    return SCHEMAS[schema_name]


@library.global_function
def parse_date(*args, **kwargs):
    from dateutil import parser
    return parser.parse(*args, **kwargs)


@library.global_function
def human_delta(delta):
    from datetime import timedelta
    import ago

    if not isinstance(delta, timedelta):
        delta = timedelta(seconds=delta)

    return ago.human(dt=delta, precision=4, past_tense='{}', future_tense='{}')


@library.global_function
def get_delta_metric_url(width):
    from static_api.utils import get_metric_path

    delta_ids_path = get_metric_path('delta_ids')
    delta_time_path = get_metric_path('delta_time')

    if not delta_ids_path:
        return

    return settings.STATIC_API_GRAPHITE_VIEWER_PREFIX + ('/render?width=%s' % width
                                                         + '&from=-6hours&until=now'
                                                         + '&lineMode=connected'
                                                         + '&target=%s' % delta_ids_path
                                                         + '&target=secondYAxis(%s)' % delta_time_path
                                                         + '&title=%s API delay' % settings.SERVICE_NAME)

library.global_function(urlencode)
library.global_function(urlparse.parse_qs)
