import os

import requests

from django.conf import settings


GET_TICKET_TIMEOUT = 0.3
AUTH_HEADERS = {'Authorization': os.getenv(str('TVMTOOL_LOCAL_AUTHTOKEN'), '')}
TVM_LOCAL_ADDRESS_TICKETS = os.getenv(str('DEPLOY_TVM_TOOL_URL'), '') + '/tvm/tickets'
TVM_SERVICE_TICKET_HEADER = 'X-Ya-Service-Ticket'

tvm2_deploy_session = requests.Session()
tvm2_deploy_session.headers.update(AUTH_HEADERS)


def get_tvm_ticket_by_deploy(service_alias):
    response = tvm2_deploy_session.get(
        url=TVM_LOCAL_ADDRESS_TICKETS,
        params={'dsts': service_alias, 'src': settings.YAUTH_TVM2_CLIENT_ID},
        timeout=GET_TICKET_TIMEOUT,
    )
    response.raise_for_status()
    json_response = response.json()
    ticket = json_response[service_alias]['ticket']
    return ticket
