# coding: utf-8
from __future__ import unicode_literals

from django.conf.urls import patterns, url


admin_urls = [
    url(r'^_admin/$',
        'admin.index',
        name='admin-index',
    ),

    url(r'^_admin/action/$',
        'admin.action',
        name='admin-action',
    ),
]

docs_urls = [
    url(
        r'^$',
        'docs.index',
        name='index',
    ),
]

system_urls = [
    url(
        r'^events/check/$',
        'system.check',
        name='events_check',
    ),
    url(
        r'^events/last/$',
        'system.last',
        name='events_last',
    ),
]

data_urls = [
    url(
        r'^(?P<resource>\w+)/?$',
        'resource.resource_view',
        name='resource',
    ),
    url(
        r'^(?P<resource>\w+)/(?P<id>\d+)/?$',
        'resource.resource_detail_view',
        name='resource-detail',
    ),
]

all_urls = admin_urls + docs_urls + system_urls + data_urls

urlpatterns = patterns('static_api.views', *all_urls)
urls = (urlpatterns, 'static_api', 'static_api')
