# coding: utf-8
from __future__ import unicode_literals

from django import http, forms
from django.conf import settings
from django.core.urlresolvers import reverse
from django.contrib import messages as django_messages
from django.shortcuts import render
from django.views.decorators.http import require_POST

from static_api import (
    message,
    actions,
    helpers,
    storage,
)


def index(request):
    return render(
        request=request,
        template_name='static_api/admin/index.html',
        context={
            'storage_manager': storage.manager,
            'message_manager': message.manager,
            'state_manager': storage.manager.get_state_manager(),
            'meta_data': helpers.get_meta(),
        }
    )


class ActionForm(forms.Form):
    action = forms.CharField(required=True)


@require_POST
def action(request):
    form = ActionForm(request.POST)

    if not form.is_valid():
        return http.HttpResponseBadRequest(form.errors.as_text())

    selected_action = form.cleaned_data['action']

    if selected_action == 'init':
        actions.run_init(reset=True)
    elif selected_action == 'ensure_indexes':
        actions.run_ensure_indexes()
    elif selected_action == 'compact':
        actions.run_compact()

    django_messages.info(
        request=request,
        message='Action `%s` started.' % selected_action.replace('_', ' ')
    )

    return http.HttpResponseRedirect(reverse('static_api:admin-index'))
