# coding: utf-8
from __future__ import unicode_literals

import operator

from django.shortcuts import render

from static_api.resources import (
    registry,
    get_resource_or_404,
)


def index(request):
    resources = sorted(
        registry.by_name.values(),
        key=operator.attrgetter('list_order'),
    )
    return render(
        request=request,
        template_name='static_api/docs/index.html',
        context={
            'resources': resources
        }
    )


@get_resource_or_404
def doc(request, resource):
    return render(
        request=request,
        template_name=resource.doc_tpl_location,
        context={
            'resource': resource,
            'registry': registry.by_name
        }
    )
