# coding: utf-8
from __future__ import unicode_literals

from django import forms

from static_api import message

from . import utils


class CheckForm(forms.Form):
    event = forms.IntegerField()


def check(request):
    """
    Ручка для проверки, накатился ли уже event с указанным id
    """

    form = CheckForm(request.GET)

    if not form.is_valid():
        return utils.build_error_json_response(msg=form.errors.as_text())

    check_id = form.cleaned_data['event']
    last_id = message.manager.get_last_message()['_id']

    is_ready = last_id >= check_id
    return utils.build_json_response({'is_ready': is_ready})


def last(request):
    """
    Ручка для получения последнего обработанного id
    """

    last_id = message.manager.get_last_message()['_id']
    return utils.build_json_response({'last_id': last_id})
