# coding: utf-8

from __future__ import unicode_literals, print_function, absolute_import, division

import os

from pythonjsonlogger.jsonlogger import JsonFormatter


DEPLOY_VARS = [
    'DEPLOY_PROJECT_ID',
    'DEPLOY_STAGE_ID',
    'DEPLOY_UNIT_ID',
    'DEPLOY_POD_ID',
    'DEPLOY_NODE_DC',
    'DEPLOY_NODE_FQDN',
    'DEPLOY_POD_TRANSIENT_FQDN',
]


class DeployJsonFormatter(JsonFormatter):
    def process_log_record(self, log_record):
        """
        :type log_record: dict
        """
        deploy_vars = {key:os.environ[key] for key in DEPLOY_VARS}

        log_record.update(deploy_vars)

        return {
            'msg': log_record.pop('message'),
            'stackTrace': log_record.pop('exc_info'),
            '@fields': log_record,
        }
