# -*- coding: utf-8 -*-

from __future__ import unicode_literals, absolute_import

import csv
from competentum.report.person import Person


def get_links(persons):
    for person in persons:
        assert isinstance(person, Person)
        yield [
            person.work_email,
            person.department_id,
            person.position or 'Должность не указана',
            person.role,
            person.inherit,
            person.hire_date,
        ]


def export_links(links, output):
    writer = csv.writer(output, delimiter=b';')
    writer.writerow(['User ID',
                     'Organizational unit ID',
                     'Title',
                     'Learning Role',
                     'Inherit',
                     'Appointed',
                     ])
    writer.writerows(([field.encode('utf-8') if isinstance(field, unicode) else field
                       for field in link]
                      for link in links))
