# -*- coding: utf-8 -*-

from __future__ import unicode_literals

from io import BytesIO
from logging import getLogger

from competentum.report.departments import get_departments, export_departments
from competentum.report.links import get_links, export_links
from competentum.report.persons import get_persons, export_persons
from competentum.settings import OAUTH_TOKEN

logger = getLogger(__name__)


def get_oauth_header():
    return {'AUTHORIZATION': 'OAuth ' + OAUTH_TOKEN}


def make_report(url):
    users_result = BytesIO()
    links_result = BytesIO()
    structure_result = BytesIO()

    header = get_oauth_header()
    logger.info('Downloading persons')
    persons_list = list(get_persons(url, header))
    logger.info('Preparing departments')
    departments_list = get_departments(persons_list, header)
    logger.info('Preparing links')
    links = get_links(persons_list)

    export_persons(persons_list, users_result)
    export_links(links, links_result)
    export_departments(departments_list, structure_result)

    result = {
        'users.csv': users_result,
        'links.csv': links_result,
        'structure.csv': structure_result,
    }

    logger.info('Done')
    return result
