# coding: utf-8
"""
Django settings for competentum project.

Generated by 'django-admin startproject' using Django 1.11.5.

For more information on this file, see
https://docs.djangoproject.com/en/1.11/topics/settings/

For the full list of settings and their values, see
https://docs.djangoproject.com/en/1.11/ref/settings/
"""

from __future__ import unicode_literals, print_function, absolute_import, division

import os

# SECURITY WARNING: keep the secret key used in production secret!
SECRET_KEY = '111'
OAUTH_TOKEN = 'AQAD-qJSJsgYAAAECNE_8ed-nE9RnIPvgrbXLFU'

try:
    execfile('/etc/competentum_secret.py')
except IOError:
    pass

from django_yauth.settings import *

# Build paths inside the project like this: os.path.join(BASE_DIR, ...)
BASE_DIR = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))

# SECURITY WARNING: don't run with debug turned on in production!
DEBUG = True

import yenv

if yenv.type == 'production':
    DEBUG = False
    STAFF_API_HOST = 'https://staff-api.yandex-team.ru'
    STAFF_HOST = 'https://staff.yandex-team.ru'
else:
    STAFF_API_HOST = 'http://staff-api.test.yandex-team.ru'
    STAFF_HOST = 'http://staff.test.yandex-team.ru'
    DEBUG = bool(int(os.getenv('DJANGO_DEBUG', 1)))

YAUTH_TYPE = 'intranet'
YAUTH_USE_SITES = False

# Quick-start development settings - unsuitable for production
# See https://docs.djangoproject.com/en/1.11/howto/deployment/checklist/

ALLOWED_HOSTS = [
    '.yandex-team.ru',
    '.yandex.net',
    '.yandex.ru',
]

# Application definition

INSTALLED_APPS = [
    'django_yauth',
    'django.contrib.contenttypes',
    'django.contrib.auth',
]

MIDDLEWARE = [
    'competentum.middleware.request_id_middleware',
    'competentum.middleware.UwsgiLogMiddleware',
    'django.middleware.common.CommonMiddleware',
    'competentum.middleware.ping_middleware',
    'django_yauth.middleware.YandexAuthMiddleware',
    'django.middleware.security.SecurityMiddleware',
]

ROOT_URLCONF = 'competentum.urls'

TEMPLATES = [
    {
        'BACKEND': 'django.template.backends.django.DjangoTemplates',
        'DIRS': [],
        'APP_DIRS': True,
        'OPTIONS': {
            'context_processors': [
                'django.template.context_processors.debug',
                'django.template.context_processors.request',
                'django.contrib.auth.context_processors.auth',
                'django.contrib.messages.context_processors.messages',
            ],
        },
    },
]

WSGI_APPLICATION = 'competentum.wsgi.application'

# Database
# https://docs.djangoproject.com/en/1.11/ref/settings/#databases

DATABASES = {
    'default': {
        'ENGINE': 'django.db.backends.sqlite3',
        'NAME': os.path.join(BASE_DIR, 'db.sqlite3'),
    }
}

# Password validation
# https://docs.djangoproject.com/en/1.11/ref/settings/#auth-password-validators

AUTH_PASSWORD_VALIDATORS = [
    {
        'NAME': 'django.contrib.auth.password_validation.UserAttributeSimilarityValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.MinimumLengthValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.CommonPasswordValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.NumericPasswordValidator',
    },
]

# Internationalization
# https://docs.djangoproject.com/en/1.11/topics/i18n/

LANGUAGE_CODE = 'en-us'

TIME_ZONE = 'UTC'

USE_I18N = True

USE_L10N = True

USE_TZ = True

# Static files (CSS, JavaScript, Images)
# https://docs.djangoproject.com/en/1.11/howto/static-files/

STATIC_URL = '/static/'

import sys

from competentum.log_formatter import DeployJsonFormatter

LOGGING = {
    'version': 1,
    'disable_existing_loggers': False,
    'formatters': {
        'default': {
            '()': DeployJsonFormatter,
            'format': '%(name)s %(created)s %(message)s %(levelno)d %(levelname)d %(pathname)s %(funcName)s %(lineno)s %(exc_info)s',
        },
    },
    'handlers': {
        'stream': {
            'class': 'logging.StreamHandler',
            'formatter': 'default',
            'stream': sys.stdout,
        },
    },
    'loggers': {
        'django': {
            'level': os.getenv('DJANGO_LOG_LEVEL', 'INFO'),
            'handlers': ['stream'],
            'propagate': True,
        },
        'requests': {
            'level': 'ERROR',
            'handlers': ['stream'],
            'propagate': True,
        },
        'py.warnings': {
            'level': 'ERROR',
            'handlers': ['stream'],
            'propagate': True,
        },
    },
    'root': {
        'level': os.getenv('DJANGO_LOG_LEVEL', 'INFO'),
        'handlers': ['stream'],
    },
}
