# coding: utf-8
from __future__ import unicode_literals, print_function, absolute_import

from io import BytesIO
from datetime import date
from logging import getLogger
import zipfile
from django.http import HttpResponse

from django_yauth.decorators import yalogin_required
from competentum.report import make_report


logger = getLogger(__name__)


def make_report_file_name():
    today = date.today().strftime('%d%m%y')
    return 'report{date}.zip'.format(date=today)


@yalogin_required
def download(request, url='yandex'):
    output = BytesIO()

    try:
        contents = make_report(url)
        logger.info('Packing result')
        _pack(contents, output)

        response = HttpResponse(output.getvalue(), content_type="application/x-zip-compressed")
        response['Content-Disposition'] = 'attachment; filename={filename}'.format(
            filename=make_report_file_name(),
        )
        return response
    finally:
        output.close()


def _pack(contents, output):
    assert isinstance(contents, dict)
    with zipfile.ZipFile(output, 'w', zipfile.ZIP_DEFLATED) as result:
        for filename, buffer in contents.items():
            assert isinstance(buffer, BytesIO)
            result.writestr(filename, buffer.getvalue())
