FROM registry.yandex.net/tools/raw-ubuntu:16.04

EXPOSE 80

COPY deps/debian-main.txt /
RUN apt-get update \
    && cat debian-main.txt | xargs apt-get install -y  \
    && apt-get clean \
    && rm -rf /var/lib/apt/lists/*

COPY deps/python-main.txt /
RUN pip install --disable-pip-version-check -i https://pypi.yandex-team.ru/simple/ wheel==0.30.0
RUN pip install --disable-pip-version-check -i https://pypi.yandex-team.ru/simple/ -r python-main.txt

COPY uwsgiconf.ini /
COPY competentum/ competentum/

CMD uwsgi --ini=/uwsgiconf.ini
