import sqlalchemy as sa

from enum import Enum

metadata = sa.MetaData()


class DocumentType(Enum):
    proposal = 0
    vacancy = 1


budget_position_fact_table = sa.Table(
    'budget_position_fact_2021_08_18',
    metadata,
    sa.Column('id', sa.BigInteger, primary_key=True, autoincrement=True),
    sa.Column('bp_code', sa.BigInteger, nullable=False),
    sa.Column('login', sa.String, nullable=True),
    sa.Column('status', sa.String, nullable=True),
    sa.Column('department_id', sa.BigInteger, nullable=True),
    sa.Column('valuestream_id', sa.BigInteger, nullable=True),
    sa.Column('event_type', sa.String, nullable=False),
    sa.Column('event_time', sa.DateTime, nullable=False),
    sa.Column('ticket1', sa.String, nullable=True),
    sa.Column('ticket2', sa.String, nullable=True),
    sa.Column('document_type', sa.Enum(DocumentType), nullable=False),
    sa.Column('document_id', sa.String, nullable=True),
    sa.Column('workflow_id', sa.String, nullable=True),
    sa.Column('hc', sa.BigInteger, nullable=True),
)
