import logging
from typing import Any, Dict

import aiohttp

from src.common.blackbox import get_tvm_service_ticket
from src.config import settings


logger = logging.getLogger(__name__)


async def has_permissions(user: Dict[str, Any], role: str) -> bool:
    department_roles_url = f'https://{settings.STAFF_API_HOST}/v3/departmentstaff'
    login = user['login']
    params = {'person.login': login, 'role': role}
    tvm_token = await get_tvm_service_ticket('staff-api')

    async with aiohttp.ClientSession(headers={settings.TVM_SERVICE_TICKET_HEADER: tvm_token}) as session:
        async with session.get(url=department_roles_url, params=params) as response:
            # TODO: raise for status
            response = await response.json()
            return len(response['result']) > 0
