from abc import abstractmethod, ABCMeta
from typing import Any, Dict


class AuthenticationInterface(metaclass=ABCMeta):
    @abstractmethod
    async def check_user_ticket(self, ticket: str) -> bool:
        pass

    @abstractmethod
    async def user_info_by_ticket(self, ticket: str) -> Dict[str, Any]:
        pass
