import logging
from functools import wraps

from starlette.responses import PlainTextResponse
from starlette.requests import Request
from ylog.context import put_to_context

from src.common.authentication_interface import AuthenticationInterface
from src.config import settings

logger = logging.getLogger(__name__)


def auth_by_tvm_only(view):
    @wraps(view)
    async def wrapper(request: Request, *args, **kwargs):
        ticket = request.headers.get(settings.TVM_USER_TICKET_HEADER)
        authentication: AuthenticationInterface = request.app.state.authentication
        if not ticket:
            return PlainTextResponse('Not authorized', 403)

        access = await authentication.check_user_ticket(ticket)
        if not access:
            return PlainTextResponse('Not authorized', 403)

        user_info = await authentication.user_info_by_ticket(ticket)
        request.state.user = user_info['users'][0]
        put_to_context('yandex_login', request.state.user['login'])
        return await view(request, *args, **kwargs)
    return wrapper
