from itertools import chain
from typing import Dict, Set, Any


class FieldMapper:
    def __init__(self, system_fields: Set[str] = None) -> None:
        super().__init__()
        self._system_fields = system_fields or {'id'}

    def map(self, source: Dict[str, Any], target_type) -> Dict[str, Any]:
        target = {'source_id': source['id']}

        for (key, value) in chain(source.items(), source.get('meta', {}).items()):
            if key not in self._system_fields and key in target_type.columns:
                target[key] = value

        return target
