from typing import Dict, Any

import aiohttp

from src.common.authentication_interface import AuthenticationInterface
from src.common import blackbox
from src.config import settings


async def _check_usr_ticket_by_deploy(ticket: str) -> bool:
    timeout = aiohttp.ClientTimeout(total=settings.GET_TVM_TICKET_TIMEOUT)
    session = aiohttp.ClientSession(timeout=timeout)
    session.headers.update(settings.LOCAL_TVM_AUTH_HEADERS)
    session.headers.update({settings.TVM_USER_TICKET_HEADER: ticket})
    async with session:
        async with session.get(url=settings.TVM_LOCAL_ADDRESS_CHECK_USER) as response:
            return response.ok


class YandexInternalAuthentication(AuthenticationInterface):
    async def user_info_by_ticket(self, ticket: str) -> Dict[str, Any]:
        return await blackbox.get_user_info_from_bb(ticket)

    async def check_user_ticket(self, ticket: str) -> bool:
        return await _check_usr_ticket_by_deploy(ticket)
