import os
from pydantic import BaseSettings, Field

from src.config.logging import configure_logging

configure_logging()


class Settings(BaseSettings):
    ENV_TYPE: str = 'development'
    DEBUG: bool = Field(False, env='DEBUG')

    STAFF_API_HOST: str = 'staff-api.yandex-team.ru'

    GET_TVM_TICKET_TIMEOUT = 0.3
    YAUTH_TVM2_CLIENT_ID = 2000053
    LOCAL_TVM_AUTH_HEADERS = {'Authorization': os.getenv(str('TVMTOOL_LOCAL_AUTHTOKEN'), '')}
    TVM_LOCAL_ADDRESS_CHECK_USER = os.getenv(str('DEPLOY_TVM_TOOL_URL'), '') + "/tvm/checkusr"
    TVM_LOCAL_ADDRESS_TICKETS = os.getenv(str('DEPLOY_TVM_TOOL_URL'), '') + "/tvm/tickets"

    TVM_USER_TICKET_HEADER = 'X-Ya-User-Ticket'
    TVM_SERVICE_TICKET_HEADER = 'X-Ya-Service-Ticket'

    ATTRIBUTE_TIMEZONE = '33'
    ATTRIBUTE_LANGUAGE = '34'

    BLACKBOX_URL = 'http://blackbox.yandex-team.ru/blackbox'
    REAL_IP_HEADER = 'X-Real-Ip'

    @property
    def blackbox_attributes(self):
        return ','.join([self.ATTRIBUTE_TIMEZONE, self.ATTRIBUTE_LANGUAGE])

    POSTGRES_DATABASE: str = Field('staffdwh', env='POSTGRES_DATABASE')
    POSTGRES_USER: str = Field('staffdatamart', env='POSTGRES_USER')
    POSTGRES_PASSWORD: str = Field('staffdatamart', env='POSTGRES_PASSWORD')
    POSTGRES_HOST: str = Field('db', env='POSTGRES_HOST')
    POSTGRES_PORT: int = Field(5432, env='POSTGRES_PORT')
    POSTGRES_POOL_MIN: int = Field(10, env='POSTGRES_POOL_MIN')
    POSTGRES_POOL_MAX: int = Field(10, env='POSTGRES_POOL_MAX')
    POSTGRES_CONNECT_TIMEOUT: int = Field(10, env='POSTGRES_CONNECT_TIMEOUT')

    @property
    def db_settings(self):
        return {
            'database': self.POSTGRES_DATABASE,
            'user': self.POSTGRES_USER,
            'password': self.POSTGRES_PASSWORD,
            'host': self.POSTGRES_HOST,
            'port': self.POSTGRES_PORT,
            'minsize': self.POSTGRES_POOL_MIN,
            'maxsize': self.POSTGRES_POOL_MAX,
            'connect_timeout': self.POSTGRES_CONNECT_TIMEOUT,
            'echo': self.DEBUG,
        }
