import selectors  # isort:skip # noqa: F401
selectors._PollLikeSelector.modify = selectors._BaseSelectorImpl.modify  # noqa: E402

import asyncio
import logging
from aiopg import sa

from src.config import settings


logger = logging.getLogger(__name__)


async def create_engine() -> sa.engine.Engine:
    if settings.ENV_TYPE in ('development', ):
        await asyncio.sleep(2.0)

    logger.info('connecting to %s:%s', settings.POSTGRES_HOST, settings.POSTGRES_PORT)
    result = await sa.create_engine(**settings.db_settings)
    return result
