import logging

from starlette.applications import Starlette
from starlette.requests import Request
from starlette.routing import Route

from src.common import JsonResponse
from src.common.yandex_internal_authentication import YandexInternalAuthentication
from src.db_engine import create_engine
from src.budget_positions.views import get_budget_positions
from src.main_tasks import start_tasks, shutdown_tasks


logger = logging.getLogger('main_webapp')


async def check(request: Request):
    async with request.app.state.engine.acquire() as conn:
        rows = await conn.execute('SELECT 1')
        result = []
        async for row in rows:
            result.append(row[0])

        return JsonResponse({'result': result})


async def on_startup_task():
    logger.info('Web app starting...')
    app.state.engine = await create_engine()
    app.state.authentication = YandexInternalAuthentication()
    await start_tasks(app)
    logger.info('Web app started')


async def on_shutdown_task():
    await shutdown_tasks(app)


app = Starlette(
    debug=True,
    routes=[
        Route('/', check),
        Route('/budget_positions', get_budget_positions),
    ],
    on_startup=[on_startup_task],
    on_shutdown=[on_shutdown_task],
)
