"""add new bpa fields

Revision ID: 2cfd757bbc34
Revises: 1759471613ad
Create Date: 2022-05-16 12:52:06.142534

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '2cfd757bbc34'
down_revision = '1759471613ad'
branch_labels = None
depends_on = None


def upgrade():
    op.create_table(
        'budget_position_2022_05_16',

        sa.Column('id', sa.BigInteger, primary_key=True),
        sa.Column('source', sa.String),
        sa.Column('source_id', sa.BigInteger, unique=True),
        sa.Column('source_action', sa.String),
        sa.Column('source_datetime', sa.DateTime),

        sa.Column('pk', sa.BigInteger, index=True),
        sa.Column('code', sa.BigInteger),
        sa.Column('headcount', sa.BigInteger, nullable=True),
        sa.Column('type', sa.String, nullable=True),
    )

    op.create_table(
        'budget_position_assignment_2022_05_16',

        sa.Column('id', sa.BigInteger, primary_key=True),
        sa.Column('source', sa.String),
        sa.Column('source_id', sa.BigInteger, unique=True),
        sa.Column('source_action', sa.String),
        sa.Column('source_datetime', sa.DateTime),

        sa.Column('pk', sa.BigInteger, index=True),
        sa.Column('created_at', sa.DateTime),
        sa.Column('modified_at', sa.DateTime),
        sa.Column('version', sa.BigInteger),
        sa.Column('native_lang', sa.String),
        sa.Column('intranet_status', sa.BigInteger),

        sa.Column('change_reason', sa.String, nullable=True),
        sa.Column('oebs_assignment_id', sa.BigInteger, nullable=True),
        sa.Column('change_registry_id', sa.BigInteger, nullable=True),

        sa.Column('budget_position_id', sa.BigInteger),
        sa.Column('name', sa.String, nullable=True),    # Will be removed
        sa.Column('status', sa.String),
        sa.Column('creates_new_position', sa.Boolean),

        sa.Column('previous_assignment_id', sa.BigInteger, nullable=True),
        sa.Column('replacement_type', sa.String),
        sa.Column('person_id', sa.BigInteger, nullable=True),
        sa.Column('vacancy_id', sa.BigInteger, nullable=True),

        sa.Column('main_assignment', sa.Boolean),
        sa.Column('department_id', sa.BigInteger),
        sa.Column('value_stream_id', sa.BigInteger),
        sa.Column('geography_id', sa.BigInteger),

        sa.Column('bonus_id', sa.BigInteger),
        sa.Column('reward_id', sa.BigInteger),
        sa.Column('review_id', sa.BigInteger),
    )


def downgrade():
    op.drop_table('budget_position_2022_05_16')
    op.drop_table('budget_position_assignment_2022_05_16')
