"""create change record table

Revision ID: a57fbbc3c4e0
Revises:
Create Date: 2021-07-05 08:00:58.643459

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = 'a57fbbc3c4e0'
down_revision = None
branch_labels = None
depends_on = None


def upgrade():
    op.create_table(
        'change_records',
        sa.Column('id', sa.BigInteger, primary_key=True),
        sa.Column('source', sa.String),
        sa.Column('source_id', sa.BigInteger, unique=True),
        sa.Column('source_date', sa.DateTime),

        sa.Column('budget_position_id', sa.BigInteger),
        sa.Column('budget_position_code', sa.BigInteger),
        sa.Column('workflow_id', sa.String),
        sa.Column('proposal_id', sa.String),
        sa.Column('vacancy_id', sa.BigInteger),

        sa.Column('workflow_created_at', sa.DateTime),
        sa.Column('workflow_confirmed_at', sa.DateTime),
        sa.Column('workflow_code', sa.String),

        sa.Column('ticket', sa.String),
        sa.Column('optional_ticket', sa.String),
        sa.Column('headcount', sa.BigInteger),
        sa.Column('department_id', sa.BigInteger),
        sa.Column('hr_product_id', sa.BigInteger),

        sa.Column('staff_id', sa.BigInteger),
        sa.Column('person_id', sa.BigInteger),
        sa.Column('login', sa.String),

        sa.Column('effective_date', sa.DateTime),
        sa.Column('dismissal_date', sa.DateTime),
        sa.Column('join_at', sa.DateTime),

        sa.Column('remove_budget_position', sa.Boolean),
        sa.Column('employment_type', sa.String),
        sa.Column('is_replacement', sa.Boolean),

        # TODO: remove this backward-compatibility
        sa.Column('resolved_at', sa.DateTime),
        sa.Column('started_at', sa.DateTime),
    )


def downgrade():
    op.drop_table('change_records')
