"""add budget position

Revision ID: bac8a35c34d8
Revises: 928f2b1301d6
Create Date: 2022-02-19 15:46:46.085360

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = 'bac8a35c34d8'
down_revision = '928f2b1301d6'
branch_labels = None
depends_on = None


def upgrade():
    op.create_table(
        'budget_position_2022_02_19',
        sa.Column('id', sa.BigInteger, primary_key=True),
        sa.Column('source', sa.String),
        sa.Column('source_id', sa.BigInteger, unique=True),
        sa.Column('pk', sa.BigInteger, index=True),
        sa.Column('code', sa.BigInteger),
        sa.Column('headcount', sa.BigInteger, nullable=True),
        sa.Column('type', sa.String, nullable=True),
    )

    op.create_table(
        'budget_position_assignment_2022_02_19',
        sa.Column('id', sa.BigInteger, primary_key=True),
        sa.Column('source', sa.String),
        sa.Column('source_id', sa.BigInteger, unique=True),
        sa.Column('pk', sa.BigInteger, index=True),
        sa.Column('change_reason', sa.String, nullable=True),
        sa.Column('change_registry_id', sa.BigInteger, nullable=True),
        sa.Column('status', sa.String),
        sa.Column('creates_new_position', sa.Boolean),
        sa.Column('previous_assignment_id', sa.BigInteger, nullable=True),
        sa.Column('replacement_type', sa.String),
        sa.Column('person_id', sa.BigInteger, nullable=True),
        sa.Column('vacancy_id', sa.BigInteger, nullable=True),
        sa.Column('main_assignment', sa.Boolean),
        sa.Column('department_id', sa.BigInteger),
        sa.Column('value_stream_id', sa.BigInteger),
        sa.Column('geography_id', sa.BigInteger),
        sa.Column('bonus_id', sa.BigInteger),
        sa.Column('reward_id', sa.BigInteger),
        sa.Column('review_id', sa.BigInteger),
    )


def downgrade():
    op.drop_table('budget_position_2022_02_19')
    op.drop_table('budget_position_assignment_2022_02_19')
