import sqlalchemy as sa

metadata = sa.MetaData()


budget_position_table = sa.Table(
    'budget_position_2022_05_16',
    metadata,
    sa.Column('id', sa.BigInteger, primary_key=True),
    sa.Column('source', sa.String),
    sa.Column('source_id', sa.BigInteger, unique=True),
    sa.Column('source_action', sa.String),
    sa.Column('source_datetime', sa.DateTime),

    sa.Column('pk', sa.BigInteger, index=True),
    sa.Column('code', sa.BigInteger),
    sa.Column('headcount', sa.BigInteger, nullable=True),
    sa.Column('type', sa.String, nullable=True),
)


budget_position_assignment_table = sa.Table(
    'budget_position_assignment_2022_05_16',
    metadata,
    sa.Column('id', sa.BigInteger, primary_key=True),
    sa.Column('source', sa.String),
    sa.Column('source_id', sa.BigInteger, unique=True),
    sa.Column('source_action', sa.String),
    sa.Column('source_datetime', sa.DateTime),

    sa.Column('pk', sa.BigInteger, index=True),
    sa.Column('created_at', sa.DateTime),
    sa.Column('modified_at', sa.DateTime),
    sa.Column('version', sa.BigInteger),
    sa.Column('native_lang', sa.String),
    sa.Column('intranet_status', sa.BigInteger),

    sa.Column('change_reason', sa.String, nullable=True),
    sa.Column('oebs_assignment_id', sa.BigInteger, nullable=True),
    sa.Column('change_registry_id', sa.BigInteger, nullable=True),

    sa.Column('budget_position_id', sa.BigInteger),
    sa.Column('name', sa.String, nullable=True),    # Will be removed
    sa.Column('status', sa.String),
    sa.Column('creates_new_position', sa.Boolean),

    sa.Column('previous_assignment_id', sa.BigInteger, nullable=True),
    sa.Column('replacement_type', sa.String),
    sa.Column('person_id', sa.BigInteger, nullable=True),
    sa.Column('vacancy_id', sa.BigInteger, nullable=True),

    sa.Column('main_assignment', sa.Boolean),
    sa.Column('department_id', sa.BigInteger),
    sa.Column('value_stream_id', sa.BigInteger),
    sa.Column('geography_id', sa.BigInteger),

    sa.Column('bonus_id', sa.BigInteger),
    sa.Column('reward_id', sa.BigInteger),
    sa.Column('review_id', sa.BigInteger),
)
