class AsyncContextManager:
    def __init__(self, return_value) -> None:
        super().__init__()
        self._return_value = return_value

    async def __aenter__(self):
        return self._return_value

    async def __aexit__(self, exc_type, exc_val, exc_tb):
        pass
