from typing import Dict, Set, Any


class FieldMapper:
    def __init__(self, system_fields: Set[str] = None) -> None:
        super().__init__()
        self._system_fields = system_fields or {'id'}

    def map(
        self,
        source_name: str,
        source: Dict[str, Any],
        target_type,
        custom: Dict[str, str] = None,
        aliases: Dict[str, str] = None,
    ) -> Dict[str, Any]:
        target = {'source_id': source['id'], 'source': source_name}

        for column in target_type.columns:
            if column.name not in self._system_fields:
                target[column.name] = source.get(column.name, None)

        if custom:
            for (target_key, source_key) in custom.items():
                target[target_key] = source[source_key]

        if aliases:
            for (target_key, source_key) in aliases.items():
                if source_key in source:
                    target[target_key] = source[source_key]

        return target
