import kikimr.public.sdk.python.persqueue.grpc_pq_streaming_api as pqlib
import kikimr.public.sdk.python.persqueue.auth as auth

from src.tvm import get_tvm_client
from src.config import settings


class LogbrokerClient:
    def __init__(self, tvm_client):
        credentials_provider = auth.TVMCredentialsProvider(
            tvm_client=tvm_client,
            destination_client_id=settings.LOGBROKER_TVM,
        )
        self.credentials_provider = credentials_provider
        self.endpoint = settings.LOGBROKER_ENDPOINT
        self.port = settings.LOGBROKER_PORT
        self.api = None

    async def _start(self) -> None:
        self.api = pqlib.PQStreamingAPI(self.endpoint, self.port)
        self.api.start().result(timeout=settings.LOGBROKER_TIMEOUT)

    async def get_consumer(self, consumer_name: str, topic_name: str) -> pqlib.PQStreamingConsumer:
        await self._start()
        configurator = pqlib.ConsumerConfigurator(topic_name, client_id=consumer_name.encode())
        consumer = self.api.create_consumer(configurator, credentials_provider=self.credentials_provider)
        return consumer

    async def stop(self) -> None:
        self.api.stop()


async def get_logbroker_client() -> LogbrokerClient:
    tvm_client = await get_tvm_client()
    return LogbrokerClient(tvm_client)
