from datetime import datetime, timedelta

from sqlalchemy.dialects.postgresql import insert


class SqlExecutor:
    def __init__(self) -> None:
        super().__init__()
        self.source_id_field_name = 'source_id'
        self.source_date_field_name = 'source_date'
        self._mutable_window = timedelta(hours=2)

    async def get_last_processed_source_date(self, connection, table):
        rows = await connection.execute(
            f'SELECT MAX({self.source_date_field_name}) FROM {table.name} WHERE {self.source_date_field_name} < %s',
            (datetime.now() - self._mutable_window,),
        )

        result = []
        async for row in rows:
            result.append(row[0])

        return None if not result else result[0]

    async def insert(self, connection, table, row):
        return await connection.execute(
            insert(table)
            .values(**row)
            .on_conflict_do_update(index_elements=[self.source_id_field_name], set_=row))
