from pydantic import BaseSettings, Field

from src.config.logging import configure_logging

configure_logging()


class Settings(BaseSettings):
    ENV_TYPE: str = 'development'
    DEBUG: bool = Field(False, env='DEBUG')

    GET_TVM_TICKET_TIMEOUT = 0.3
    YAUTH_TVM2_CLIENT_ID = 2000053
    TVMTOOL_LOCAL_AUTHTOKEN: str = Field('', env='TVMTOOL_LOCAL_AUTHTOKEN')
    DEPLOY_TVM_TOOL_URL: str = Field('', env='DEPLOY_TVM_TOOL_URL')

    LOGBROKER_ENDPOINT = 'vla.logbroker.yandex.net'
    LOGBROKER_PORT = 2135
    LOGBROKER_CONSUMER_NAME = 'staff/data-swamp-test-consumer'
    LOGBROKER_TOPIC_NAME = 'staff/data-swamp-test'
    LOGBROKER_CHUNK_SIZE = 1000
    LOGBROKER_TIMEOUT = 30
    LOGBROKER_TVM = 2001059

    POSTGRES_DATABASE: str = Field('dataswamp', env='POSTGRES_DATABASE')
    POSTGRES_USER: str = Field('dataswamp', env='POSTGRES_USER')
    POSTGRES_PASSWORD: str = Field('dataswamp', env='POSTGRES_PASSWORD')
    POSTGRES_HOST: str = Field('db', env='POSTGRES_HOST')
    POSTGRES_PORT: int = Field(5432, env='POSTGRES_PORT')
    POSTGRES_POOL_MIN: int = Field(10, env='POSTGRES_POOL_MIN')
    POSTGRES_POOL_MAX: int = Field(10, env='POSTGRES_POOL_MAX')
    POSTGRES_CONNECT_TIMEOUT: int = Field(10, env='POSTGRES_CONNECT_TIMEOUT')

    STAFF_HOST: str = Field('staff-oebs-test-awacs-balancer.in.yandex-team.ru/api', env='STAFF_HOST')

    @property
    def db_settings(self):
        return {
            'database': self.POSTGRES_DATABASE,
            'user': self.POSTGRES_USER,
            'password': self.POSTGRES_PASSWORD,
            'host': self.POSTGRES_HOST,
            'port': self.POSTGRES_PORT,
            'minsize': self.POSTGRES_POOL_MIN,
            'maxsize': self.POSTGRES_POOL_MAX,
            'target_session_attrs': 'read-write',
            'connect_timeout': self.POSTGRES_CONNECT_TIMEOUT,
            'echo': self.DEBUG,
        }

    @property
    def database_url(self):
        return (
            'postgresql://{user}:{password}@{host}:{port}/{database}?target_session_attrs=read-write'
            .format(**self.db_settings)
        )
