import os
import sys
from logging import config


LOGGING = {
    'version': 1,
    'disable_existing_loggers': False,
    'formatters': {
        'file': {'()': 'ylog.FileFormatter'},
        'json': {
            '()': 'ylog.format.QloudJsonFormatter',
         },
    },
    'handlers': {
        'stream': {
            'class': 'logging.StreamHandler',
            'formatter': os.getenv('STREAM_LOG_FORMATTER', 'json'),
            'stream': sys.stdout,
        }
    },
    'root': {
        'handlers': ['stream'],
        'level': os.getenv('LOG_LEVEL', 'INFO'),
    }
}


def configure_logging():
    config.dictConfig(LOGGING)
