from pydantic import Field

from src.config.development import Settings as DefaultSettings


class Settings(DefaultSettings):
    ENV_TYPE: str = Field('production', env='ENV_TYPE')

    LOGBROKER_CONSUMER_NAME = 'staff/data-swamp-production-consumer'
    LOGBROKER_TOPIC_NAME = 'staff/data-swamp-production'

    POSTGRES_HOST: str = Field(
        'sas-wtc34cxfz7wmy1z6.db.yandex.net,vla-p829esjmdp4x873n.db.yandex.net',
        env='POSTGRES_HOST',
    )
    POSTGRES_PORT: int = Field(6432, env='POSTGRES_PORT')
