import aiohttp
from typing import Union

from tvmauth import BlackboxTvmId as BlackboxClientId
from tvm2 import TVM2Deploy

from src.config import settings


AUTH_HEADERS = {'Authorization': settings.TVMTOOL_LOCAL_AUTHTOKEN}
TVM_LOCAL_ADDRESS_TICKETS = settings.DEPLOY_TVM_TOOL_URL + '/tvm/tickets'
TVM_SERVICE_TICKET_HEADER = 'X-Ya-Service-Ticket'


async def get_tvm_ticket(name: str, server_id: Union[int, str] = None):
    if server_id is None:
        server_id = name

    params = {'dsts': server_id, 'src': settings.YAUTH_TVM2_CLIENT_ID}
    timeout = aiohttp.ClientTimeout(total=settings.GET_TVM_TICKET_TIMEOUT)
    session = aiohttp.ClientSession(headers=AUTH_HEADERS, timeout=timeout)

    async with session:
        async with session.get(url=TVM_LOCAL_ADDRESS_TICKETS, params=params) as response:
            json_response = await response.json()
            return json_response[name]['ticket']


async def get_tvm_client():
    return TVM2Deploy(
        blackbox_client=BlackboxClientId.ProdYateam,
        client_id=settings.YAUTH_TVM2_CLIENT_ID,
    )

