"""Restore BudgetPositionFact table

Revision ID: 3caacdc9a1c3
Revises: 
Create Date: 2021-08-18 13:49:24.517625

"""
from alembic import op
import sqlalchemy as sa

from src.enitites.document_type import DocumentType


# revision identifiers, used by Alembic.
revision = '3caacdc9a1c3'
down_revision = '4ab225e2f024'
branch_labels = None
depends_on = None


def upgrade():
    op.create_table(
        'budget_position_fact_2021_08_18',
        sa.Column('id', sa.BigInteger, primary_key=True, autoincrement=True),
        sa.Column('bp_code', sa.BigInteger, nullable=False),
        sa.Column('login', sa.String, nullable=True),
        sa.Column('status', sa.String, nullable=True),
        sa.Column('department_id', sa.BigInteger, nullable=True),
        sa.Column('valuestream_id', sa.BigInteger, nullable=True),
        sa.Column('event_type', sa.String, nullable=False),
        sa.Column('event_time', sa.DateTime, nullable=False),
        sa.Column('ticket1', sa.String, nullable=True),
        sa.Column('ticket2', sa.String, nullable=True),
        sa.Column('document_type', sa.Enum(DocumentType), nullable=False),
        sa.Column('document_id', sa.String, nullable=True),
        sa.Column('hc', sa.BigInteger, nullable=True),
    )


def downgrade():
    op.drop_table('budget_position_fact_2021_08_18')
