"""Create DWH structure

Revision ID: 4ab225e2f024
Create Date: 2021-07-25 14:39:59.482426

"""
from alembic import op
import sqlalchemy as sa

from src.enitites import SourceType


# revision identifiers, used by Alembic.
revision = '4ab225e2f024'
down_revision = None
branch_labels = None
depends_on = None


def upgrade():
    op.create_table(
        'budget_position_entity',
        sa.Column('id', sa.BigInteger, primary_key=True, autoincrement=True),
        sa.Column('budget_position_code', sa.BigInteger, nullable=False),
        sa.Column('created_at', sa.DateTime, nullable=False),
        sa.Column('modified_at', sa.DateTime, nullable=False),
        sa.Column('external_id', sa.BigInteger, nullable=False),
    )

    op.create_table(
        'hr_product_entity',
        sa.Column('id', sa.BigInteger, primary_key=True, autoincrement=True),
        sa.Column('created_at', sa.DateTime, nullable=False),
        sa.Column('modified_at', sa.DateTime, nullable=False),
        sa.Column('external_id', sa.BigInteger, nullable=False),
    )

    op.create_table(
        'department_entity',
        sa.Column('id', sa.BigInteger, primary_key=True, autoincrement=True),
        sa.Column('url', sa.String, unique=True, index=True, nullable=False),

        sa.Column('created_at', sa.DateTime, nullable=False),
        sa.Column('modified_at', sa.DateTime, nullable=False),
        sa.Column('external_id', sa.BigInteger, nullable=False),
    )

    op.create_table(
        'staff_entity',
        sa.Column('id', sa.BigInteger, primary_key=True, autoincrement=True),
        sa.Column('login', sa.String, unique=True, index=True, nullable=False),

        sa.Column('created_at', sa.DateTime, nullable=False),
        sa.Column('modified_at', sa.DateTime, nullable=False),
        sa.Column('external_id', sa.BigInteger, nullable=False),
    )

    op.create_table(
        'vacancy_entity',

        sa.Column('id', sa.BigInteger, primary_key=True, autoincrement=True),
        sa.Column('source_id', sa.BigInteger),
        sa.Column('name', sa.String),
        sa.Column('created_at', sa.DateTime, nullable=False),
        sa.Column('modified_at', sa.DateTime, nullable=False),
        sa.Column('external_id', sa.BigInteger, nullable=False),
    )

    op.create_table(
        'department_role_entity',

        sa.Column('id', sa.BigInteger, primary_key=True, autoincrement=True),
        sa.Column('role_type', sa.String, unique=True, index=True, nullable=False),
        sa.Column('created_at', sa.DateTime, nullable=False),
        sa.Column('modified_at', sa.DateTime, nullable=False),
        sa.Column('external_id', sa.BigInteger, nullable=False),
    )

    op.create_table(
        'department_role_fact',
        sa.Column('id', sa.BigInteger, primary_key=True, autoincrement=True),

        sa.Column('entity_id', sa.BigInteger, sa.ForeignKey('department_entity.id')),
        sa.Column('source_modification_id', sa.BigInteger, nullable=False),
        sa.Column('source_modification_date', sa.DateTime, nullable=False),
    )

    op.create_table(
        'staff_role_in_department_link',
        sa.Column('id', sa.BigInteger, primary_key=True, autoincrement=True),

        sa.Column('role_id', sa.BigInteger, sa.ForeignKey('department_role_entity.id')),
        sa.Column('department_role_fact_id', sa.BigInteger, sa.ForeignKey('department_role_fact.id')),
        sa.Column('staff_id', sa.BigInteger, sa.ForeignKey('staff_entity.id')),

        sa.Column('created_at', sa.DateTime, nullable=False),
        sa.Column('modified_at', sa.DateTime, nullable=False),
        sa.Column('external_id', sa.BigInteger, nullable=False),
    )

    op.create_table(
        'department_fact',

        sa.Column('id', sa.BigInteger, primary_key=True, autoincrement=True),

        sa.Column('entity_id', sa.BigInteger, sa.ForeignKey('department_entity.id'), nullable=False),
        sa.Column('valid_from', sa.DateTime, nullable=False),
        sa.Column('is_deleted', sa.Boolean, nullable=False),
        sa.Column('source', sa.Enum(SourceType), nullable=False),
        sa.Column('source_proposal_id', sa.String, nullable=True),
        sa.Column('name_en', sa.String, nullable=False),
        sa.Column('name_ru', sa.String, nullable=False),
        sa.Column('parent_id', sa.BigInteger, sa.ForeignKey('department_entity.id'), nullable=True),
        sa.Column('source_modification_id', sa.BigInteger, nullable=False),
        sa.Column('source_modification_date', sa.DateTime, nullable=False),
    )

    op.create_table(
        'hr_product_fact',

        sa.Column('id', sa.BigInteger, primary_key=True, autoincrement=True),
        sa.Column('entity_id', sa.BigInteger, sa.ForeignKey('hr_product_entity.id')),

        sa.Column('source_modification_id', sa.BigInteger, nullable=False),
        sa.Column('source_modification_date', sa.DateTime, nullable=False),
    )

    op.create_table(
        'budget_position_fact',

        sa.Column('id', sa.BigInteger, primary_key=True, autoincrement=True),
        sa.Column('entity_id', sa.BigInteger, sa.ForeignKey('budget_position_entity.id'), nullable=False),
        sa.Column('valid_from', sa.DateTime, nullable=False),
        sa.Column('is_deleted', sa.Boolean, nullable=False),
        sa.Column('source', sa.Enum(SourceType), nullable=False),
        sa.Column('source_workflow_id', sa.String, nullable=True),
        sa.Column('source_proposal_id', sa.String, nullable=True),
        sa.Column('vacancy_id', sa.BigInteger, sa.ForeignKey('vacancy_entity.id'), nullable=True),
        sa.Column('workflow_code', sa.String, nullable=True),
        sa.Column('ticket1', sa.String, nullable=True),
        sa.Column('ticket2', sa.String, nullable=True),
        sa.Column('hc', sa.BigInteger, nullable=True),
        sa.Column('hr_product_id', sa.BigInteger, sa.ForeignKey('hr_product_entity.id')),
        sa.Column('department_id', sa.BigInteger, sa.ForeignKey('department_entity.id'), nullable=True),

        sa.Column('source_modification_id', sa.BigInteger, nullable=False),
        sa.Column('source_modification_date', sa.DateTime, nullable=False),
    )


def downgrade():
    op.drop_table('budget_position_fact')
    op.drop_table('hr_product_fact')
    op.drop_table('department_fact')
    op.drop_table('staff_role_in_department_link')
    op.drop_table('department_role_fact')
    op.drop_table('department_role_entity')
    op.drop_table('vacancy_entity')
    op.drop_table('staff_entity')
    op.drop_table('department_entity')
    op.drop_table('hr_product_entity')
    op.drop_table('budget_position_entity')

    sourcetype = sa.Enum(*[], name='sourcetype')
    sourcetype.drop(op.get_bind(), checkfirst=False)
