"""add temporary indices

Revision ID: c75ef66f9033
Revises: ad8ce4969c18
Create Date: 2021-09-09 11:55:41.192043

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = 'c75ef66f9033'
down_revision = 'ad8ce4969c18'
branch_labels = None
depends_on = None


def upgrade():
    op.create_index(
        op.f('ix_budget_position_fact_2021_08_18_event_time'),
        'budget_position_fact_2021_08_18',
        ['event_time'],
        unique=False,
    )
    op.create_index(
        op.f('ix_budget_position_fact_2021_08_18_bp_code_event_time'),
        'budget_position_fact_2021_08_18',
        ['bp_code', 'event_time'],
        unique=False,
    )
    op.create_index(
        op.f('ix_budget_position_fact_2021_08_18_login_event_time'),
        'budget_position_fact_2021_08_18',
        ['login', 'event_time'],
        unique=False,
    )
    op.create_index(
        op.f('ix_budget_position_fact_2021_08_18_department_id_event_time'),
        'budget_position_fact_2021_08_18',
        ['department_id', 'event_time'],
        unique=False,
    )


def downgrade():
    op.drop_index(
        op.f('ix_budget_position_fact_2021_08_18_event_time'),
        table_name='budget_position_fact_2021_08_18',
    )
    op.drop_index(
        op.f('ix_budget_position_fact_2021_08_18_bp_code_event_time'),
        table_name='budget_position_fact_2021_08_18',
    )
    op.drop_index(
        op.f('ix_budget_position_fact_2021_08_18_login_event_time'),
        table_name='budget_position_fact_2021_08_18',
    )
    op.drop_index(
        op.f('ix_budget_position_fact_2021_08_18_department_id_event_time'),
        table_name='budget_position_fact_2021_08_18',
    )
