from typing import Dict, Set, Any


class FieldMapper:
    def __init__(self, system_fields: Set[str] = None) -> None:
        super().__init__()
        self._system_fields = system_fields or {'id'}

    def map(
        self,
        source_name: str,
        source: Dict[str, Any],
        target_type,
        custom: Dict[str, str] = None,
    ) -> Dict[str, Any]:
        target = {'source_id': source['id'], 'source': source_name}

        for (key, value) in source.items():
            if key not in self._system_fields and key in target_type.columns:
                target[key] = value

        for (target_key, source_key) in custom.items():
            target[target_key] = source[source_key]

        return target
