from pydantic import BaseSettings, Field

from src.config.logging import configure_logging

configure_logging()


class Settings(BaseSettings):
    ENV_TYPE: str = 'development'
    DEBUG: bool = Field(False, env='DEBUG')

    POSTGRES_DATABASE: str = Field('staffdwh', env='POSTGRES_DATABASE')
    POSTGRES_USER: str = Field('staffdwh', env='POSTGRES_USER')
    POSTGRES_PASSWORD: str = Field('staffdwh', env='POSTGRES_PASSWORD')
    POSTGRES_HOST: str = Field('db', env='POSTGRES_HOST')
    POSTGRES_PORT: int = Field(5432, env='POSTGRES_PORT')
    POSTGRES_POOL_MIN: int = Field(10, env='POSTGRES_POOL_MIN')
    POSTGRES_POOL_MAX: int = Field(10, env='POSTGRES_POOL_MAX')
    POSTGRES_CONNECT_TIMEOUT: int = Field(10, env='POSTGRES_CONNECT_TIMEOUT')

    DATASWAMP_POSTGRES_DATABASE: str = Field('dataswamp', env='DATASWAMP_POSTGRES_DATABASE')
    DATASWAMP_POSTGRES_USER: str = Field('staffdwh', env='DATASWAMP_POSTGRES_USER')
    DATASWAMP_POSTGRES_PASSWORD: str = Field('staffdwh', env='DATASWAMP_POSTGRES_PASSWORD')
    DATASWAMP_POSTGRES_HOST: str = Field('db', env='DATASWAMP_POSTGRES_HOST')
    DATASWAMP_POSTGRES_PORT: int = Field(5432, env='DATASWAMP_POSTGRES_PORT')
    DATASWAMP_POSTGRES_POOL_MIN: int = Field(10, env='DATASWAMP_POSTGRES_POOL_MIN')
    DATASWAMP_POSTGRES_POOL_MAX: int = Field(10, env='DATASWAMP_POSTGRES_POOL_MAX')
    DATASWAMP_POSTGRES_CONNECT_TIMEOUT: int = Field(10, env='DATASWAMP_POSTGRES_CONNECT_TIMEOUT')

    @property
    def db_settings(self):
        return {
            'database': self.POSTGRES_DATABASE,
            'user': self.POSTGRES_USER,
            'password': self.POSTGRES_PASSWORD,
            'host': self.POSTGRES_HOST,
            'port': self.POSTGRES_PORT,
            'minsize': self.POSTGRES_POOL_MIN,
            'maxsize': self.POSTGRES_POOL_MAX,
            'target_session_attrs': 'read-write',
            'connect_timeout': self.POSTGRES_CONNECT_TIMEOUT,
            'echo': self.DEBUG,
        }

    @property
    def dataswamp_db_settings(self):
        return {
            'database': self.DATASWAMP_POSTGRES_DATABASE,
            'user': self.DATASWAMP_POSTGRES_USER,
            'password': self.DATASWAMP_POSTGRES_PASSWORD,
            'host': self.DATASWAMP_POSTGRES_HOST,
            'port': self.DATASWAMP_POSTGRES_PORT,
            'minsize': self.DATASWAMP_POSTGRES_POOL_MIN,
            'maxsize': self.DATASWAMP_POSTGRES_POOL_MAX,
            'connect_timeout': self.DATASWAMP_POSTGRES_CONNECT_TIMEOUT,
            'echo': self.DEBUG,
        }

    @property
    def database_url(self):
        return (
            'postgresql://{user}:{password}@{host}:{port}/{database}?target_session_attrs=read-write'
            .format(**self.db_settings)
        )
