from abc import ABCMeta, abstractmethod
from dataclasses import dataclass
from datetime import datetime
from typing import List


@dataclass
class RegistryChangeEvent:
    id: int
    source_id: int
    workflow_id: str
    workflow_code: str
    proposal_id: str
    budget_position_id: int
    budget_position_code: int
    started_at: datetime
    resolved_at: datetime
    effective_date: datetime
    login: str
    join_at: datetime
    staff_id: int
    person_id: int
    ticket: str
    optional_ticket: str
    vacancy_id: int
    department_id: int
    hr_product_id: int
    headcount: int


class DataswampRegistryRepositoryInterface(metaclass=ABCMeta):
    @abstractmethod
    async def all_changes(self, from_id: int) -> List[RegistryChangeEvent]:
        pass
