from abc import ABCMeta, abstractmethod
from dataclasses import dataclass
from datetime import datetime
from typing import List

from src.enitites.document_type import DocumentType
from src.enitites.event_type import EventType


@dataclass
class BpChange:
    dataswamp_id: int
    source_id: int
    bp_code: int
    login: str
    status: str or None
    department_id: int
    valuestream_id: int or None
    event_type: EventType
    event_time: datetime
    ticket1: str
    ticket2: str
    document_type: DocumentType
    document_id: str
    workflow_id: str
    hc: int


class DwhBpChangesRepositoryInterface(metaclass=ABCMeta):
    @abstractmethod
    async def add_changes(self, changes: List[BpChange]):
        pass
