import sqlalchemy as sa

from src.enitites import SourceType
from src.tables.metadata import metadata


budget_position_fact_table = sa.Table(
    'budget_position_fact',
    metadata,
    sa.Column('id', sa.BigInteger, primary_key=True, autoincrement=True),
    sa.Column('entity_id', None, sa.ForeignKey('budget_position_entity.id'), nullable=False),
    sa.Column('valid_from', sa.DateTime, nullable=False),
    sa.Column('is_deleted', sa.Boolean, nullable=False),
    sa.Column('source', sa.Enum(SourceType), nullable=False),
    sa.Column('source_workflow_id', sa.String, nullable=True),
    sa.Column('source_proposal_id', sa.String, nullable=True),
    sa.Column('vacancy_id', None, sa.ForeignKey('vacancy_entity.id'), nullable=True),
    sa.Column('workflow_code', sa.String, nullable=True),
    sa.Column('ticket1', sa.String, nullable=True),
    sa.Column('ticket2', sa.String, nullable=True),
    sa.Column('hc', sa.BigInteger, nullable=True),
    sa.Column('hr_product_id', None, sa.ForeignKey('hr_product_entity.id')),
    sa.Column('department_id', None, sa.ForeignKey('department_entity.id'), nullable=True),

    sa.Column('source_modification_id', sa.BigInteger, nullable=False),
    sa.Column('source_modification_date', sa.DateTime, nullable=False),
)
